unit IWDBGrids;
{PUBDIST}

{$I IWCompilerDefines.inc}

// Credits:
//
// Thanks goes out to David Mustard and Huw Reddick
// for their contributions to the IWDBGrid and
// their continued support of IntraWeb and IntraWeb users
//
// Thanks Guys!!!

interface

uses
  {$IFDEF CLR}
  Borland.Vcl.Contnrs,
  {$ENDIF}
  {$IFDEF VSNET}
  System.Collections,
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb,
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  Classes,
  DB,
  IWControl, IWGrids, IWHTMLTag, IWTypes, IWColor, IWRenderContext,IWGridCommon, 
  IWBaseInterfaces, IWMarkupLanguageTag{$IFDEF VSNET}, IWScriptEvents, IWDBGridColumnConverter, IWFont{$ENDIF};

type
  THighlightCompare = (hcNone, hcEqualTo, hcNotEqualTo, hcContains,
    hcDoesNotContain, hcGreaterThan, hcLessThan);

  {$IFDEF VSNET}
  [TypeConverterAttribute(typeof(TIWDBGridColumnConverter))]
  {$ENDIF}
  TIWDBGridColumn = class(TIWGridCell{$IFDEF VSNET}, ICloneable{$ENDIF})
  protected
    FBlobCharLimit: Integer;
    FCompareValue: string;
    FCompareHighlight: THighlightCompare;
    FDataField: string;
    FLinkField: string;
    FRawText: Boolean;
    FOnClick: TIWOnClickWithValue;
    FOnTitleClick: TNotifyEvent;
    FTitle: TIWGridCell;
    //
    procedure SetDataField(const AValue: string);
    procedure SetTitle(const AValue: TIWGridCell);
    function GetDisplayName: string; override;

    procedure AssignTo(ADest: TPersistent); override;
  public
    constructor Create(ACollection: TCollection);  overload; override;
    destructor Destroy; override;
   {$IFDEF VSNET}
    constructor Create; reintroduce; overload;
    constructor Create(
		    AAlignment: TAlignment;
		    ABGColor: TIWColor;
		    AControl: TIWCustomControl;
		    ADoSubmitValidation: Boolean;
        AWebFont: TIWFont;
		    AHeader: Boolean;
		    AHeight: string;
		    AHint: string;
		    ATag: TObject;
		    AText: string;
		    AVAlign: TIWGridVAlign;
		    AVisible: Boolean;
		    AWidth: string;
		    AWrap: Boolean;


		    ATitle: TIWGridCell;
    		ADataField: string;
    		ALinkField: string;

        ABlobCharLimit: Integer;
    		ACompareValue: string;
    		ACompareHighlight: THighlightCompare;
		    ARawText: Boolean

		    ); reintroduce; overload;
		function Clone: TObject; virtual;
    {$ENDIF}

    function RenderSelf(AGrid: TIWCustomGrid; const ARow: Integer;
      const AColumn: Integer; AContext: TIWComponent40Context; AText: string = ''): TIWHTMLTag; override;
  published
    property BlobCharLimit: Integer read FBlobCharLimit write FBlobCharLimit;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property CompareValue: string read FCompareValue write FCompareValue;
    property CompareHighlight: THighlightCompare read FCompareHighlight write FCompareHighlight;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write SetDataField;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property LinkField: string read FLinkField write FLinkField;
    property RawText: Boolean read FRawText write FRawText;
    property OnClick: TIWOnClickWithValue read FOnClick write FOnClick;
    property OnTitleClick: TNotifyEvent read FOnTitleClick write FOnTitleClick;
    property Title: TIWGridCell read FTitle write SetTitle;
  end;

  TIWDBGrid = class;

{$IFDEF VSNET}
  TIWDBGridColumns = class(TOwnedCollection, IList)
  private
    function getItem(AIndex: Integer): TIWDBGridColumn;
    procedure setItem(AIndex: Integer; AValue: TIWDBGridColumn);
  public
    // IEnumerable
    function GetEnumerator: IEnumerator;
    // ICollection
    procedure CopyTo(AArray: &Array; AIndex: Integer);
    function get_SyncRoot: &Object;
    function get_IsSynchronized: Boolean;
    function get_Count: Integer;
    // IList
    function Add(AObject: &Object): Integer; {reintroduce; }overload;
    function get_Item(AIndex: Integer): &Object;
    procedure set_Item(AIndex: Integer; AItem: &Object);
    function Contains(value: &Object): Boolean;
    function IndexOf(AObject: &Object): Integer; overload; // reintroduce;
    procedure Insert(AIndex: Integer; AObject: &Object); overload;//reintroduce;

    procedure AddRange(aValues: array of &Object);

    function get_IsReadOnly: Boolean;
    function get_IsFixedSize: Boolean;
    procedure Remove(AObject: &Object);
    procedure RemoveAt(AIndex: Integer);

    property Items[AIndex: Integer]: TIWDBGridColumn read getItem write setItem;
  end;
{$ELSE}
  TIWDBGridColumns = class(TOwnedCollection)
  protected
    FGrid: TIWDBGrid;
  public
    property Grid: TIWDBGrid read FGrid write FGrid;
  end;
{$ENDIF}


{$IFDEF VSNET}
  [EditorAttribute('Atozed.Intraweb.Design.SetEditor, Atozed.Intraweb.Design', typeof(UITypeEditor))]
{$ENDIF}


  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBGrid.bmp}
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBGrid), 'TIWDBGrid.bmp'),
    TIWToolPalette('Intraweb DB Controls')]
  {$ENDIF}
  TIWDBGrid = class(TIWCustomGrid, IIWSubmitControl)
  protected
    FScrollToCurrentRow : Boolean;
    FSubmitParam : String;
    FColumns: TIWDBGridColumns;
    FCurrentField: TField;
    FDataSource: TDataSource;
    FFooterRowCount: Integer;
    FFromStart: Boolean;
    FHighlightRows: Boolean;
    FHighlightColor: TIWColor;
    FOptions: TIWDBGridOptions;
    FRecordCount: Integer;
    FRenderBuffer: TIWMarkupLanguageTagCollection;
    FRowIsCurrent: Boolean;
    FRowLimit: integer;
    FRowClick: Boolean;
    FRollOver: Boolean;
    FRollOverColor: TIWColor;
    FRowHeaderColor: TIWColor;
    FRowAlternateColor: TIWColor;
    FRowCurrentColor: TIWColor;
    FRefreshMode: TIWDBGridRefreshMode;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure RenderCells(AContext: TIWComponent40Context; AGridTag: TIWHTMLTag); override;
    procedure SetColumns(AValue: TIWDBGridColumns);
    procedure Submit(const AValue: string); override;
    function IsValidCell(ACell: TIWGridCell): Boolean; override;

    procedure Loaded; override;
    procedure InitControl; override;
  public
    procedure CreateImplicitColumns;
    destructor Destroy; override;

    procedure RefreshData(AContext: TIWComponent40Context; AGridTag: TIWHTMLTag);
    function GetSubmitParam : String;

    property CurrentField: TField read FCurrentField;
    property RecordCount: Integer read FRecordCount;
    property RowIsCurrent: Boolean read FRowIsCurrent;

    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    property InternalDatasource : TDataSource read FDataSource;
    {$ENDIF}
  published
    property ScrollToCurrentRow : Boolean read FScrollToCurrentRow write FScrollToCurrentRow;  
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Columns: TIWDBGridColumns read FColumns write SetColumns;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property FooterRowCount: Integer read FFooterRowCount write FFooterRowCount;
    property FriendlyName;
    property FromStart: Boolean read FFromStart write FFromStart;
    property HighlightColor: TIWColor read FHighlightColor write FHighlightColor;
    property HighlightRows: Boolean read FHighlightRows write FHighlightRows;
    property Options: TIWDBGridOptions read FOptions write FOptions;
    property RefreshMode: TIWDBGridRefreshMode read FRefreshMode write FRefreshMode;
    property RowLimit: integer read FRowLimit write FRowLimit;
    property RollOver: Boolean read FRollOver write FRollOver;
    property RowClick: Boolean read FRowClick write FRowClick;
    property RollOverColor: TIWColor read FRollOverColor write FRollOverColor;
    property RowHeaderColor: TIWColor read FRowHeaderColor write FRowHeaderColor;
    property RowAlternateColor: TIWColor read FRowAlternateColor write FRowAlternateColor;
    property RowCurrentColor: TIWColor read FRowCurrentColor write FRowCurrentColor;
    property TabOrder;
  end;

implementation

uses
  IWDBCommon, IWHTML40Interfaces, IWServerControllerBase, IWResourceStrings,
  SWSystem, SWStrings, SysUtils, IWBaseHTMLControl, IWBaseRenderContext;

{$IFDEF VSNET}
constructor TIWDBGridColumn.Create();
begin
  Create(nil);
end;

constructor TIWDBGridColumn.Create(
		    AAlignment: TAlignment;
		    ABGColor: TIWColor;
		    AControl: TIWCustomControl;
		    ADoSubmitValidation: Boolean;
        AWebFont: TIWFont;
		    AHeader: Boolean;
		    AHeight: string;
		    AHint: string;
		    ATag: TObject;
		    AText: string;
		    AVAlign: TIWGridVAlign;
		    AVisible: Boolean;
		    AWidth: string;
		    AWrap: Boolean;
    

		    ATitle: TIWGridCell;
    		ADataField: string;
    		ALinkField: string;
    
        ABlobCharLimit: Integer;
    		ACompareValue: string;
    		ACompareHighlight: THighlightCompare;
		    ARawText: Boolean

		    );
begin
  Create(nil);
	Alignment:= AAlignment;
  BGColor:= ABGColor;
  Control:= AControl;
  DoSubmitValidation:= ADoSubmitValidation;
  WebFont:= AWebFont;
  Header:= AHeader;
  Height:= AHeight;
  Hint:= AHint;
  Tag:= ATag;
  Text:= AText;
  VAlign:= AVAlign;
  Visible:= AVisible;
  Width:= AWidth;
  Wrap:= AWrap;

  DataField := ADataField;
  LinkField := ALinkField;
  Title := ATitle;
  
  BlobCharLimit := ABlobCharLimit;
  CompareValue := ACompareValue;
  CompareHighlight := ACompareHighlight;
	RawText := ARawText;
end;


function TIWDBGridColumn.Clone: TObject;
begin
  result := TIWDBGridColumn.Create(nil);
  TIWDBGridColumn(result).Assign(Self);
end;

Type
  TCollectionEnumerator = class(TObject, IEnumerator)
  private
    FCurrent: Integer;
    FCollection: TIWDBGridColumns;
  protected
    function MoveNext(): Boolean;
    function get_Current: &Object;
    procedure Reset;
  public
    constructor Create(ACollection: TIWDBGridColumns);
  end;

  constructor TCollectionEnumerator.Create(ACollection: TIWDBGridColumns);
  begin
    inherited Create;
    FCollection := ACollection;
  end;

  function TCollectionEnumerator.MoveNext(): Boolean;
  begin
    FCurrent := FCurrent + 1;
    result := FCurrent <= FCollection.Count;
  end;

  function TCollectionEnumerator.get_Current: System.Object;
  begin
    result := FCollection.Items[FCurrent - 1].Clone();
  end;

  procedure TCollectionEnumerator.Reset;
  begin
    FCurrent := 0;
  end;

function TIWDBGridColumns.getItem(AIndex: Integer): TIWDBGridColumn;
begin
  Result := TIWDBGridColumn(inherited Items[AIndex]);
end;

procedure TIWDBGridColumns.setItem(AIndex: Integer; AValue: TIWDBGridColumn);
begin
  inherited Items[AIndex] := AValue;
end;

// IEnumerable
function TIWDBGridColumns.GetEnumerator: IEnumerator;
begin
  result := TCollectionEnumerator.Create(Self);
end;

// ICollection
procedure TIWDBGridColumns.CopyTo(AArray: &Array; AIndex: Integer);
Var
  i: Integer;
begin
  if Assigned(AArray) then begin
    if AIndex >= 0 then begin
      if AArray.Rank = 1 then begin
        if (AArray.Length > AIndex) and (AArray.Length - AIndex <= get_Count) then begin
          for i := 0 to get_Count - 1 do begin
            AArray.SetValue(Items[i].Clone(), AIndex + i);
          end;
          Exit;
        end;
        if (get_Count = 0) and (AIndex = 0) then exit;
      end;
      raise ArgumentException.Create;
    end else begin
      raise ArgumentOutOfRangeException.Create;
    end;
  end else begin
    raise ArgumentNullException.Create;
  end;
end;

function TIWDBGridColumns.get_SyncRoot: &Object;
begin
  result := Self;
end;

function TIWDBGridColumns.get_IsSynchronized: Boolean;
begin
  result := false;
end;

function TIWDBGridColumns.get_Count: Integer;
begin
  result := Count;
end;

// IList
function TIWDBGridColumns.Add(AObject: &Object): Integer;
begin
  inherited Add.Assign(MarshalByRefObject(AObject));
  result := IndexOf(AObject);
end;

function TIWDBGridColumns.get_Item(AIndex: Integer): &Object;
begin
  result := Items[AIndex];
end;

procedure TIWDBGridColumns.set_Item(AIndex: Integer; AItem: &Object);
begin
  Items[AIndex] := TIWDBGridColumn(AItem);
end;

function TIWDBGridColumns.Contains(value: &Object): Boolean;
begin
  result := IndexOf(value) >= 0;
end;

function TIWDBGridColumns.IndexOf(AObject: &Object): Integer;
Var
  i: Integer;
begin
  result := -1;
  for i := 0 to Count - 1 do begin
    if Items[i] = AObject then begin
      result := i;
      break;
    end;
  end;
end;

procedure TIWDBGridColumns.Insert(AIndex: Integer; AObject: &Object);
begin
  Insert(AIndex).Assign(MarshalByRefObject(AObject));
end;

procedure TIWDBGridColumns.AddRange(aValues: array of &Object);
Var
  i,j: Integer;
begin
  for i := Low(aValues) to High(aValues) do begin
    if aValues[i] is System.Array then begin
      for j := 0 to System.Array(aValues[i]).Length-1 do begin
        AddRange(System.Array(aValues[i]).GetValue(j));
      end;
    end else begin    
      Add.Assign(MarshalByRefObject(aValues[i]))
    end;    
  end;
end;


function TIWDBGridColumns.get_IsReadOnly: Boolean;
begin
  result := false;
end;

function TIWDBGridColumns.get_IsFixedSize: Boolean;
begin
  result := false;
end;

procedure TIWDBGridColumns.Remove(AObject: &Object);
begin
  Delete(IndexOf(AObject));
end;

procedure TIWDBGridColumns.RemoveAt(AIndex: Integer);
begin
  Delete(AIndex);
end;

{$ENDIF}

{ TIWDBGrid }

procedure TIWDBGrid.InitControl;
begin
  inherited;
  FScrollToCurrentRow := False;
  FFromStart := True;
  FOptions := [dgShowTitles];
  UseFrame := True;

  {$IFDEF VSNET}
  FRollOverColor := System.Drawing.Color.Empty;
  FHighlightColor := System.Drawing.Color.Empty;
  FRowHeaderColor := System.Drawing.Color.Empty;
  FRowAlternateColor := System.Drawing.Color.Empty;
  FRowCurrentColor := System.Drawing.Color.Empty;
  {$ELSE}
  FRollOverColor := clNone;
  FHighlightColor := clNone;
  FRowHeaderColor := clNone;
  FRowAlternateColor := clNone;
  FRowCurrentColor := clNone;
  {$ENDIF}

  FColumns := TIWDBGridColumns.Create(Self, TIWDBGridColumn);
  FColumns.Grid := Self;
  FRenderBuffer := nil;
end;

destructor TIWDBGrid.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  FreeAndNil(FRenderBuffer);
  FreeAndNil(FColumns);
  inherited;
end;

procedure TIWDBGrid.CreateImplicitColumns;
var
  i: integer;
  LField: TField;
begin
  if Columns.Count = 0 then begin
    for i := 0 to FDatasource.Dataset.FieldList.Count - 1 do begin
      LField := FDatasource.Dataset.Fields[i];
      if LField.Visible then begin
        with TIWDBGridColumn(Columns.Add) do begin
          DataField := LField.FieldName;
          Grid := Self;
        end;
      end;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBGrid.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBGrid.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
var
  i: integer;
begin
  inherited;
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if (FDataSource <> nil) and (FDatasource.Equals(AComponent)) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;

    if Assigned(FColumns) then begin
      for i := 0 to FColumns.Count - 1 do begin
        if AComponent = TIWDBGridColumn(FColumns.Items[i]).Control then begin
          TIWDBGridColumn(FColumns.Items[i]).Control := nil;
        end;
      end;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBGrid.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBGrid.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(DataSet);
end;

function TIWDBGrid.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBGrid.RenderCells(AContext: TIWComponent40Context; AGridTag: TIWHTMLTag);
var
  LJScript: TStrings;
begin
  inherited;
  DoRefreshControl := True;
  LJScript := TStringList.Create;
  try
    with LJScript do begin
      Add('function rollon_' + HTMLName +'(row,where){ ');
      Add('var tablecolor;');
      Add('if (where == ''over''){');
      Add(' currentcolor=' + iif(AContext.WebApplication.IsPartialUpdate, 'IWTop().', '') + 'document.getElementById(row).style.backgroundColor');
      Add(' ' + iif(AContext.WebApplication.IsPartialUpdate, 'IWTop().', '') + 'document.getElementById(row).style.backgroundColor=''' + ColorToRGBString(FRollOverColor) + ''' ');
      Add(' }else{ ');
      Add(' ' + iif(AContext.WebApplication.IsPartialUpdate, 'IWTop().', '') + 'document.getElementById(row).style.backgroundColor=currentcolor; }');
      Add('}');
    end;
    TIWPageContext40(AContext.PageContext).AddToJavaScriptOnce(LJScript.Text);
  finally
    FreeAndNil(LJSCript);
  end;

  case RefreshMode of
    rmAutomatic: begin
        if CheckDataSource(FDataSource) then begin
          if not InEditMode(FDataSource.Dataset) then begin
            RefreshData(AContext, AGridTag);
          end;
        end else begin
          RefreshData(AContext, AGridTag);
        end;
      end;
    rmAlways: begin
        RefreshData(AContext, AGridTag);
      end
  end;
  if FRenderBuffer <> nil then begin
    AGridTag.Contents.AddTagCollection(FRenderBuffer);
  end;
end;

procedure TIWDBGrid.SetColumns(AValue: TIWDBGridColumns);
begin
  Columns.Assign(AValue);
end;

procedure TIWDBGrid.Submit(const AValue: string);
var
  LColumn: TIWDBGridColumn;
  LValue: string;
begin
  FSubmitParam := AValue;
  LValue := AValue;
  if Copy(LValue, 1, 1) = 'C' then begin
    LColumn := TIWDBGridColumn(Columns.Items[StrToInt(Copy(LValue, 2, MaxInt))]);
    if Assigned(LColumn.OnTitleClick) then begin
      LColumn.OnTitleClick(LColumn);
    end;
  end else begin
    LColumn := TIWDBGridColumn(Columns.Items[StrToInt(Fetch(LValue, '_'))]);
    if Assigned(LColumn.OnClick) then begin
      LColumn.OnClick(LColumn, LValue);
    end;
  end;
end;

function TIWDBGrid.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

procedure TIWDBGrid.RefreshData(AContext: TIWComponent40Context; AGridTag: TIWHTMLTag);

  function CheckForHighlighting(ADataSet: TDataSet): Boolean;
  var
    LVariant: array of Boolean;
    i: Integer;
    j: Integer;
    k: Integer;
  begin
    Result := False;
    //j := 0;
    k := 0;
    SetLength(LVariant, Columns.Count);
    for i := 0 to High(LVariant) do begin
      with TIWDBGridColumn(Columns.Items[i]) do begin
        if (Visible) and (Length(DataField) > 0) then begin
          LVariant[i] := false;
          if CompareHighlight <> hcNone then begin
            Inc(k);
          end;
          FCurrentField := ADataSet.FieldByName(DataField);
          j := CompareText(FCurrentField.Text, CompareValue);
          Case CompareHighlight of
            hcEqualTo: LVariant[i]:=(j=0);
            hcNotEqualTo: LVariant[i]:=FCurrentField.Text <> CompareValue;
            hcContains: LVariant[i]:=(Pos(CompareValue, FCurrentField.Text) <> 0);
            hcDoesNotContain: LVariant[i]:=(Pos(CompareValue, CurrentField.Text) = 0);
            hcGreaterThan: LVariant[i]:=(j>0);
            hcLessThan: LVariant[i]:=(j<0);
          end;
        end;
      end;
    end;
    j := 0;
    if k=0 then begin
      Exit;
    end;
    for i := 0 to High(LVariant) do begin
      if (LVariant[i]=True) then begin
        Inc(j);
      end;
    end;
    SetLength(LVariant, 0);
    Result := j=k;
  end;

var
  i: Integer;
  s: string;
  LActualColNo: Integer;
  LBookmark: string;
  LCell: TIWDBGridColumn;
  LColNo: Integer;
  LData: TDataset;
  LRecNo: Integer;
  LRowLimit: integer;
  LAfterNext: Boolean;
  LHighlightRow: Boolean;
  LAlternateRow: Boolean;
  LTmpTag: TIWHTMLTag;
  LBlobStream: TStringStream;
  LRowID : string;
  LScrollToCurrentRowCode : string;

  f : integer;
{$IFDEF CLR}
  LDetailDataSets: TObjectList;
{$ELSE}
  LDetailDataSets: TList;
{$ENDIF}
  LDetailBookmarks: TList;
begin
  if Assigned(FRenderBuffer) then
    FRenderBuffer.Clear
  else
    FRenderBuffer := TIWMarkupLanguageTagCollection.Create(nil, TIWHTMLTag);

  FRowIsCurrent := False;
  FCurrentField := nil;
  LAfterNext := false;
  if CheckDataSource(FDataSource) then begin
    if InEditMode(FDataSource.Dataset) then begin
      raise Exception.Create(RSNoRefereshWhileInEdit);
    end;
    CreateImplicitColumns;
    // Title Row
    if dgShowTitles in Options then begin
      with FRenderBuffer.AddTag('tr') do begin
        if dgIndicator in Options then begin
          with Contents.AddTag('th') do begin
            Contents.AddText('&nbsp');
            if RowHeaderColor <> {$IFDEF VSNET}System.Drawing.Color.Empty{$ELSE}clNone{$ENDIF} then begin
              AddColor('BGCOLOR', RowHeaderColor);
            end;
          end;
        end;
        LActualColNo := 0;
        for LColNo := 0 to Columns.Count - 1 do begin
          with TIWDBGridColumn(Columns.Items[LColNo]) do begin
            if Visible then begin
              LCell := TIWDBGridColumn.Create(nil); try
                LCell.Assign(Title);
                LCell.Grid := Self;
                if Assigned(OnTitleClick) then begin
                  DoSubmitValidation := LCell.DoSubmitValidation;
                  LTmpTag := SubmitLink(LCell.Text, 'C' + IntToStr(LColNo), False, Acontext.Browser); try
                  LtmpTag.AddStringParam('CLASS', Title.Font.CSSStyle);
                  LCell.Text := LTmpTag.Render;
                  finally FreeAndNil(LTmpTag); end;
                end;
                with Contents.AddTagAsObject(LCell.RenderSelf(Self, 0, LActualColNo, AContext)) do begin;
                  if RowHeaderColor <> {$IFDEF VSNET}System.Drawing.Color.Empty{$ELSE}clNone{$ENDIF} then begin
                    AddColor('BGCOLOR', RowHeaderColor);
                  end;
                end;
                Inc(LActualColNo);
              finally FreeAndNil(LCell); end;
            end;
          end;
        end;
      end;
    end;
    // Data Rows
    LData := FDataSource.Dataset;
    LData.DisableControls;

{$IFDEF CLR}
  	LDetailDataSets := TObjectList.Create;
{$ELSE}
  	LDetailDataSets := TList.Create;
{$ENDIF}
  	LDetailBookmarks := TList.Create;

    LData.GetDetailDataSets(LDetailDataSets);
    for f := 0 to Pred(LDetailDataSets.Count) do
    begin
      LDetailBookmarks.Add(TDataSet(LDetailDatasets[f]).GetBookmark);
    end;
    LBookmark := LData.Bookmark; try
      // First or Refresh MUST be called otherwise Calc Fields may not be updated.
      if FromStart or (LBookmark='') then begin
        LData.First;
      end;
      if RowLimit = 0 then begin
        LRowLimit := MaxInt;
      end else begin
        LRowLimit := RowLimit;
        // This causes the top row to be on a rowlimit boundary and not to move with the record
        // itself.
        if LData.RecNo > -1 then begin
          LData.MoveBy(-((LData.RecNo - 1) mod LRowLimit));
        end;
      end;
      for LRecNo := 1 to LRowLimit do begin
        if LAfterNext then begin
          Break;
        end;
        FRowIsCurrent := LBookmark = LData.Bookmark;

        with FRenderBuffer.AddTag('TR') do
        begin
           {$IFDEF CLR}
           LRowID := Format('%d%d', [TimeStampToMSecs(DateTimeToTimeStamp(Now)), LRecNo]);
           {$ELSE}
           LRowID := Format('%d%d', [integer(Self), LRecNo]);
           {$ENDIF}
           AddStringParam('ID', LRowID);
           if FRollover then
           begin
              AddStringParam('OnMouseOut', 'rollon_' + HTMLName + '(' + LRowID+ ','''')');
              AddStringParam('OnMouseOver', 'rollon_' + HTMLName + '(' + LRowID + ',''over'')');
           end;

          FRowIsCurrent := (LBookmark = LData.Bookmark);


          LHighlightRow := False;
          if FHighlightRows then
            LHighlightRow := CheckForHighlighting(FDataSource.DataSet);

          LAlternateRow := False;
          if (FRowAlternateColor <> {$IFDEF VSNET}System.Drawing.Color.Empty{$ELSE}clNone{$ENDIF}) and (LRecNo mod 2 = 0)
            and (not LHighlightRow) then
              LAlternateRow := True;

          if (FRowIsCurrent) and (FRowCurrentColor <> {$IFDEF VSNET}System.Drawing.Color.Empty{$ELSE}clNone{$ENDIF}) then
            AddColor('BGCOLOR', FrowCurrentColor)
          else begin
            If LAlternateRow then
              AddColor('BGCOLOR', FRowAlternateColor);
            If LHighlightRow then
              AddColor('BGCOLOR', FHighlightColor);
          end;

          if dgIndicator in Options then begin
            if RowIsCurrent then begin
              with Contents.AddTag('TD') do
                Contents.AddText('*');
            end else begin
              with Contents.AddTag('TD') do
                Contents.AddText('&nbsp ');
            end;
          end;
          LActualColNo := 0;
          for LColNo := 0 to Columns.Count - 1 do begin
            with TIWDBGridColumn(Columns.Items[LColNo]) do begin
              if Visible then begin
                //TODO: Cache fields in an array
                FCurrentField := nil;
                if Length(DataField) > 0 then begin
                  FCurrentField := LData.FieldByName(DataField);
                end;
                LCell := TIWDBGridColumn.Create(nil); try
                  LCell.Grid := Self;
                  AssignTo(LCell);
                  // Will be nil if user created extra columns for custom use in events or for
                  // controls
                  if FCurrentField <> nil then begin
                    // Retrieve data to display
                    if CurrentField.DataType in [ftBlob, ftMemo] then begin
                      LBlobStream := TStringStream.Create(''); try
                        (CurrentField as TBlobField).SaveToStream(LBlobStream);
                        S := LBlobStream.DataString;
                      finally
                        LBlobStream.Free;
                      end;
                      if (BlobCharLimit > 0) and (Length(s) > BlobCharLimit) then begin
                        s := Copy(s, 1, BlobCharLimit) + '...';
                      end;
                      if not LCell.RawText then begin
                        LCell.Text := TextToHTML(s);
                      end else begin
                        LCell.Text := s;
                      end;
                    end else if CurrentField.DataType = ftGraphic then begin
                      LCell.Text := '';
                    end else begin
                      if not LCell.RawText then begin
                        LCell.Text := TextToHTML(CurrentField.DisplayText);
                      end else begin
                        LCell.Text := CurrentField.DisplayText;
                      end;
                    end;
                    // Linked fields
                    if Length(LinkField) > 0 then begin
                      DoSubmitValidation := LCell.DoSubmitValidation;
                      if not RowClick then begin
                        LTmpTag := SubmitLink( LCell.Text
                          , IntToStr(LColNo) + '_' + LData.FieldByName(LinkField).AsString, False, AContext.Browser );
                        LCell.Text := LTmpTag.Render; // TODO: remove the usage of strings
                        LTmpTag.Free;
                      end else begin
                        LCell.Text := TextToHTML(CurrentField.DisplayText);
                        if not DesignMode then begin
                          AddStringParam('OnClick', 'SubmitClickConfirm(''' + HTMLName + ''','''
                            + IntToStr(LColNo) + '_'
                            + LData.FieldByName(LinkField).AsString + ''', true, '''')');
                        end;
                        AddStringParam('STYLE', 'cursor:hand;');
                      end;
                    end;
                  end;
                  //
                  Contents.AddTagAsObject(LCell.RenderSelf(Self, LRecNo, LActualColNo, AContext));
                  Inc(LActualColNo);
                finally FreeAndNil(LCell); end;
              end;
            end;
          end;
        end;
        LData.Next;
        LAfterNext := LData.EOF;
        FRecordCount := LRecNo;

        if FScrollToCurrentRow and FRowIsCurrent then begin
          LScrollToCurrentRowCode := iif(AContext.WebApplication.IsPartialUpdate, 'IWTop().', '')
             + 'document.getElementById("' + HTMLName +
            '").scrollTop = ' + iif(AContext.WebApplication.IsPartialUpdate, 'IWTop().', '') + 'document.getElementById("' + LRowID + '").offsetTop - 40;';

          with AContext.PageContext as TIWPageContext40 do begin
            if WebApplication.IsPartialUpdate then begin
              AddToUpdateInitProc(LScrollToCurrentRowCode);
            end else begin
              AddToInitProc(LScrollToCurrentRowCode);
            end;
          end;
        end;

      end;
    finally
      set_RenderSize(UseFrame or (UseSize and ((RowLimit = 0) or (FRecordCount = RowLimit))));
      if LBookmark <> '' then begin
        LData.Bookmark := LBookmark;
      end else begin
        LData.First;
      end;
      LData.EnableControls;
      for f := 0 to Pred(LDetailDataSets.Count) do
      begin
        if TDataSet(LDetailDatasets[f]).RecordCount > 0 then
        begin
          if TDataSet(LDetailDatasets[f]).BookmarkValid(TBookmark(LDetailBookmarks[f])) then
          begin
            TDataSet(LDetailDatasets[f]).GotoBookmark(TBookmark(LDetailBookmarks[f]));
          end;
        end;
      end;
      FreeAndNil(LDetailDataSets);
      FreeAndNil(LDetailBookmarks);
    end;
    // Footer Rows
    FRowIsCurrent := False;
    if FooterRowCount > 0 then begin
      with FRenderBuffer.AddTag('TR') do begin
        for i := -FooterRowCount to -1 do begin
          if dgIndicator in Options then begin
            with Contents.AddTag('th') do begin
              Contents.AddText('&nbsp');
            end;
          end;
          LActualColNo := 0;
          for LColNo := 0 to Columns.Count - 1 do begin
            with TIWDBGridColumn(Columns.Items[LColNo]) do begin
              if Visible then begin
                //TODO: Cache fields in an array
                FCurrentField := nil;
                if Length(DataField) > 0 then begin
                  FCurrentField := LData.FieldByName(DataField);
                end;
                 LCell := TIWDBGridColumn.Create(nil);
                 try
                    LCell.Grid := Self;
                    AssignTo(LCell);
                    Contents.AddTagAsObject(LCell.RenderSelf(Self, i, LActualColNo, AContext));
                    Inc(LActualColNo);
                 finally
                    FreeAndNil(LCell);
                 end;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure TIWDBGrid.Loaded;
var
  i: Integer;
begin
  inherited Loaded;

  // Update Column titles with field.DisplayName
  for i := 0 to Columns.Count - 1 do begin
    if (FDataSource <> nil) and (FDataSource.DataSet <> nil) then
      if (FDataSource.DataSet.FindField(TIWDBGridColumn(Columns.Items[i]).DataField) <> nil) and
        (TIWDBGridColumn(Columns.Items[i]).Title.Text = '') then
        TIWDBGridColumn(Columns.Items[i]).Title.Text := FDataSource.DataSet.FieldByName(TIWDBGridColumn(Columns.Items[i]).DataField).DisplayName;
  end;
end;

function TIWDBGrid.IsValidCell(ACell: TIWGridCell): Boolean;
Var
  LCell: TCollectionItem;
begin
  LCell := FColumns.FindItemID(ACell.ID);
  result := LCell = ACell;
end;

{ TIWDBGridColumn }

procedure TIWDBGridColumn.AssignTo(ADest: TPersistent);
begin
  if ADest is TIWDBGridColumn then begin
    with ADest as TIWDBGridColumn do begin
      OnClick := Self.OnClick;
      BlobCharLimit := Self.BlobCharLimit;
      CompareValue := Self.CompareValue;
      CompareHighlight := Self.CompareHighlight;
      DataField := Self.DataField;
      LinkField := Self.LinkField;
      RawText := Self.RawText;
      OnTitleClick := Self.OnTitleClick;
      Title := Self.Title;
      Grid := Self.Grid;
    end;
  end;
  inherited AssignTo(ADest);
end;

constructor TIWDBGridColumn.Create(ACollection: TCollection);
begin
  inherited;
  FBGColor := {$IFDEF VSNET}System.Drawing.Color.Empty{$ELSE}clNone{$ENDIF};
  // DONT make headers. It forces center and bolding which gets wierd with font overrides
  FTitle := TIWGridCell.Create(nil);
  FTitle.Alignment := taCenter;
  FCompareHighlight := hcNone;
  FDataField := '';
  FLinkField := '';
  if ACollection is TIWDBGridColumns then
  begin
    Grid := (ACollection as TIWDBGridColumns).FGrid;
  end;
end;

destructor TIWDBGridColumn.Destroy;
begin
  FreeAndNil(FTitle);
  inherited;
end;

function TIWDBGridColumn.GetDisplayName: string;
begin
  if Length(FDataField) > 0 then begin
    Result := FDataField
  end else begin
    Result := inherited GetDisplayName;
  end;
end;

function TIWDBGridColumn.RenderSelf(AGrid: TIWCustomGrid; const ARow,
  AColumn: Integer; AContext: TIWComponent40Context; AText: string): TIWHTMLTag;
var
  LControl : TIWCustomControl;
begin
  // This code exists for the sole purpose of preventing the associated
  // cell controls to be rendered for all the grid rows. Doing the following
  // will cause the associated control to be rendered for the current row
  // only.
  LControl := Control;
  if not TIWDBGrid(AGrid).RowIsCurrent then
     Control := NIL;
  Result := inherited RenderSelf(AGrid, ARow, AColumn, AContext, AText);
  Control := LControl;
end;

procedure TIWDBGridColumn.SetDataField(const AValue: string);
begin
  FDataField := AValue;
  // Only set caption if its empty, or is the same as the field name
  if (Length(Title.Text) = 0) or (Title.Text = AValue) then begin
    Title.Text := AValue;
  end;
end;

procedure TIWDBGridColumn.SetTitle(const AValue: TIWGridCell);
begin
  FTitle.Assign(AValue);
end;

end.

